#include <iostream>
#include <cstdio>
#include <vector>
#include <algorithm>
#include <string>
#include <queue>
#include <set>
#include <cstring>
using namespace std;


const int maxn = 20500;
const int maxm = 100500;
int e[maxm][2];
int d[maxm];
vector <int> g[maxn];
const int inf = 2e9 + 100;

priority_queue <pair<int, int> > qu;

int getOth(int eid, int v)
{
	return e[eid][0] + e[eid][1] - v;
}

void dij(int s, int dp[] )
{
	dp[s] = 0;
	qu.push(make_pair(-dp[s], s) );
	while (!qu.empty() )
	{
		int v = qu.top().second;
		int cd = - qu.top().first;
		qu.pop();
		if (cd != dp[v] )
			continue;
		for (int i = 0; i < (int) g[v].size(); i++)
		{
			int eid = g[v][i];
			int nv = getOth(eid, v);
			int nd = d[eid] + cd;
			if (nd < dp[nv] )
			{
				dp[nv] = nd;
				qu.push(make_pair(-dp[nv], nv) );
			}
		}
	}
}


int ds[maxn];
int df[maxn];

struct Event
{
	int x, id, t;
	Event() : x(), id(), t() {}
	Event(int _x, int _id, int _t) : x(_x), id(_id), t(_t) {}
	bool operator < (const Event &A) const
	{
		if (x != A.x)
			return x < A.x;
		return id < A.id;
	}
};

vector <Event> ev;

int main()
{

	int n, m;
	scanf("%d%d", &n, &m);
	for (int i = 0; i < m; i++)
	{
		scanf("%d%d%d", &e[i][0], &e[i][1], &d[i] );
		e[i][0]--;
		e[i][1]--;
		g[e[i][0] ].push_back(i);
		g[e[i][1] ].push_back(i);
	}
	for (int i = 0; i < n; i++)
		ds[i] = df[i] = inf;
	dij(0, ds);
	dij(n - 1, df);
	int mind = ds[n - 1];
	
	for (int i = 0; i < m; i++)
	{
		int a = e[i][0];
		int b = e[i][1];
		if (ds[a] > ds[b] )
			swap(a, b);
		if (ds[a] + (long long) d[i] + df[b] != (long long) mind)
			continue;
		ev.push_back(Event(ds[a], i, 0) );
		ev.push_back(Event(ds[b], i, 1) );
	}
	sort(ev.begin(), ev.end() );

	set <int> openId;
	vector <int> answer;

	for (int i = 0; i < (int) ev.size(); i++)
	{
		int x = ev[i].x;
		int id = ev[i].id;
		int t = ev[i].t;

		if (t == 0)
			openId.insert(id);
		else
			openId.erase(id);
		
		if (i != (int) ev.size() - 1 && ev[i + 1].x != ev[i].x && (int) openId.size() == 1)
		{
			answer.push_back(*openId.begin() );
		}
	}

	sort(answer.begin(), answer.end() );
	printf("%d\n", (int) answer.size() );
	for (int i = 0; i < (int) answer.size(); i++)
		printf("%d ", answer[i] + 1);

	return 0;
}
